/********************************************************************
 * (C) Copyright 1998 by Hewlett-Packard GmbH. All rights reserved. *
 ********************************************************************/
/*
*******************************************************************************
* File:         dyndata.c
* Description:  Dynamic Capabilities initialized data ONLY !!!
*				******* Do NOT add code to this file ********
* Author:       SCR, BID PL24 R&D
* Created:      Jun 19, 1998
* Package:      E2925A C-API
*******************************************************************************
*/

#if defined(_MSC_VER)
# pragma data_seg("dyndata_c","FAR_DATA")
#elif defined(__BORLANDC__)
# pragma option -dc
# pragma warn -use
# pragma warn -cln
#endif /* _MSC_VER etc. */

#include <typedefs.h>
#include <dyndefs.h>
#include <ladata.h>


/* ------------------------------------------------------------------------
 * Data fields
 * Note: Leave the NULL at the end of the Stringlists. The compiler needs
 * it.
 * ------------------------------------------------------------------------ */

/* replaced by corresponding table in names.h */
#if 0
/* ------------------------------------------------------------------------
 *  Xact Compiler String Lists follow here
 * ------------------------------------------------------------------------ */
const b_param_stringlisttype pci_cmd_table[] = {
  { "Int_ack",		 0UL },
  { "Special",		 1UL },
  { "Io_read",		 2UL },
  { "Io_write",		 3UL },
  { "Reserved_4",    	 4UL },
  { "Reserved_5",    	 5UL },
  { "Mem_read",		 6UL },
  { "M_read",		 6UL },
  { "Mem_write",	 7UL },
  { "M_write",	         7UL },
  { "Reserved_8", 	 8UL },
  { "Reserved_9",  	 9UL },
  { "Config_Read",	10UL },
  { "Config_Write",	11UL },
  { "Readmultiple",	12UL },
  { "Dual_Address",	13UL },
  { "Readline",	        14UL },
  { "Writeinvalidate",	15UL },
  { NULL, 0 }
};

const b_param_stringlisttype term_table[] = {
  { "noterm", 	 0UL },
  { "retry",	 1UL },
  { "disconnect",2UL },
  { "discon"    ,2UL },
  { "abort",	 3UL },
  { NULL, 0 }
};

const b_param_stringlisttype toggle_table[] = {
  { "stable", 	 0UL },
  { "toggle",	 1UL },
  { NULL, 0 }
};

const b_param_stringlisttype waits_table[] = {
  { "hang",	B_M_WAITS_HANG },
  { NULL, 0 } };

/* this feature is not supported by the Ichiban any longer (due to timing) */
/* We still accept waitmode for compatibility reasons, but the hardware    */
/* ignores this value. Make this active if the second cut can do it.       */
const b_param_stringlisttype stepmode_table[] = {
  { "stable", 	 0UL },
  { "inverted",	 1UL },
  { "toggling",  2UL },
  { "sso",	 3UL },
  { NULL, 0 }
};

const b_param_stringlisttype lock_table[] = {
  { "lock", 	 1UL },
  { "hidelock",	 3UL },
  { "unchange",  0UL },
  { "unlock",	 2UL },
  { NULL, 0 }
};

#endif

const b_param_stringlisttype byten_table[] = {
  { "all", 	0x0UL },
  { "none",	0xfUL },
  { "byte0",	0xeUL },
  { "byte1",	0xdUL },
  { "byte2",	0xbUL },
  { "byte3",	0x7UL },
  { "word0",	0xcUL },
  { "word1",	0x3UL },
  { "dword0",	0x0UL },
  { NULL, 0 }
};

const b_param_stringlisttype onoff_table[] = {
  { "off",	 0UL },
  { "on", 	 1UL },
  { NULL, 0 }
};

const b_param_stringlisttype yesno_table[] = {
  { "yes", 	 1UL },
  { "no",	 0UL },
  { "true",      1UL },
  { "false",	 0UL },
  { NULL, 0 }
};

  
/* ------------------------------------------------------------------------
 * ------------------------------------------------------------------------
 * Some things are solved using Tables for the different Hardwares
 * These things are signals for trace memory and pattern terms.
 * ------------------------------------------------------------------------ */

/* the layout of the signaltable is as follows: (squeeze it into b_paraminfo)
 * new:  name, nameshort (always NULL), startbitpos (in min_val),
 * width (in max_val), default, NULL, shiftvalue (in paramrule). 
 * the remaining infos within the struct are not entered here, the compiler
 * just leaves them uninitialized, but we do not need them
 * the official table in the analyzer class is built there */
/* every list needs a terminating line (important !! )                      */

b_param_infotype e2925a_signal_table[] = {
  { "AD32"      ,NULL,	 0,  32,  0,   NULL,   0,   B_SIG_AD32    },
  { "CBE3_0"    ,NULL,	32,   4,  0,   NULL,   0,   B_SIG_CBE3_0  },
  { "FRAME"     ,NULL,	40,   1,  1,   NULL,   0,   B_SIG_FRAME   },
  { "IRDY"      ,NULL,	42,   1,  1,   NULL,   0,   B_SIG_IRDY 	  },
  { "TRDY"      ,NULL,	41,   1,  1,   NULL,   0,   B_SIG_TRDY 	  },
  { "DEVSEL"    ,NULL,	43,   1,  1,   NULL,   0,   B_SIG_DEVSEL  }, 
  { "STOP"      ,NULL,	44,   1,  1,   NULL,   0,   B_SIG_STOP 	  },
  { "IDSEL"     ,NULL,	45,   1,  0,   NULL,   0,   B_SIG_IDSEL   },
  { "PERR"      ,NULL,	46,   1,  1,   NULL,   0,   B_SIG_PERR 	  },
  { "SERR"      ,NULL,	47,   1,  1,   NULL,   0,   B_SIG_SERR 	  },
  { "REQ"       ,NULL,	48,   1,  1,   NULL,   0,   B_SIG_REQ     },
  { "GNT"       ,NULL,	49,   1,  1,   NULL,   0,   B_SIG_GNT     },
  { "LOCK"      ,NULL,	50,   1,  1,   NULL,   0,   B_SIG_LOCK 	  },
  { "SDONE"     ,NULL,	55,   1,  1,   NULL,   0,   B_SIG_SDONE   },
  { "SBO"       ,NULL,	56,   1,  1,   NULL,   0,   B_SIG_SBO     },
  { "PAR"       ,NULL,	53,   1,  0,   NULL,   0,   B_SIG_PAR     },
  { "RST"       ,NULL,	39,   1,  1,   NULL,   0,   B_SIG_RESET   },
  { "berr"      ,NULL,	54,   1,  1,   NULL,   0,   B_SIG_BERR    },
  { "ACK64"     ,NULL,	 0,   0,  1,   NULL,   0,   B_SIG_ACK64   },
  { "REQ64"     ,NULL,	 0,   0,  1,   NULL,   0,   B_SIG_REQ64   },
  { "b_state"   ,NULL,	36,   3,  0,   NULL,   4,   B_SIG_b_state },
  { "m_act"     ,NULL,	52,   1,  0,   NULL,   0,   B_SIG_m_act   },
  { "t_act"     ,NULL,	51,   1,  0,   NULL,   0,   B_SIG_t_act   },
  { "m_lock"    ,NULL,	66,   1,  0,   NULL,   0,   B_SIG_m_lock  },
  { "t_lock"    ,NULL,	65,   1,  0,   NULL,   0,   B_SIG_t_lock  },
  { "trigger3"  ,NULL,	60,   1,  0,   NULL,   0,   B_SIG_trigger3},
  { "trigger2"  ,NULL,	59,   1,  0,   NULL,   0,   B_SIG_trigger2},
  { "trigger1"  ,NULL,	58,   1,  0,   NULL,   0,   B_SIG_trigger1},
  { "trigger0"  ,NULL,	57,   1,  0,   NULL,   0,   B_SIG_trigger0},
  { "INTA"      ,NULL,	61,   1,  0,   NULL,   0,   B_SIG_INTA    },
  { "INTB"      ,NULL,	62,   1,  0,   NULL,   0,   B_SIG_INTB    },
  { "INTC"      ,NULL,	63,   1,  0,   NULL,   0,   B_SIG_INTC    },
  { "INTD"      ,NULL,	64,   1,  0,   NULL,   0,   B_SIG_INTD    },
  { "gap"       ,NULL,	67,   1,  0,   NULL,   0,   B_SIG_gap     },
  { "_gapold"   ,NULL,	67,   1,  0,   NULL,   0,   B_SIG_samplequal },
  {"_gap_clocks",NULL,   0,  32,  1,   NULL,   0,   B_SIG__gap_clocks},
  {NULL         ,NULL,   0,   0,  0,   NULL,   0,   B_SIG_NO_LABEL} /* terminating line */
};

b_param_infotype e2925a_deep_signal_table[] = {
  {"AD32"       ,NULL,   0,  32,  0,   NULL,   0,   B_SIG_AD32      }, 
  {"CBE3_0"     ,NULL,  32,   4,  0,   NULL,   0,   B_SIG_CBE3_0    }, 
  {"FRAME"      ,NULL,  40,   1,  1,   NULL,   0,   B_SIG_FRAME     }, 
  {"IRDY"       ,NULL,  42,   1,  1,   NULL,   0,   B_SIG_IRDY      }, 
  {"TRDY"       ,NULL,  41,   1,  1,   NULL,   0,   B_SIG_TRDY      }, 
  {"DEVSEL"     ,NULL,  43,   1,  1,   NULL,   0,   B_SIG_DEVSEL    }, 
  {"STOP"       ,NULL,  44,   1,  1,   NULL,   0,   B_SIG_STOP      }, 
  {"IDSEL"      ,NULL,  45,   1,  0,   NULL,   0,   B_SIG_IDSEL     }, 
  {"PERR"       ,NULL,  46,   1,  1,   NULL,   0,   B_SIG_PERR      }, 
  {"SERR"       ,NULL,  47,   1,  1,   NULL,   0,   B_SIG_SERR      }, 
  {"REQ"        ,NULL,  48,   1,  1,   NULL,   0,   B_SIG_REQ       }, 
  {"GNT"        ,NULL,  49,   1,  1,   NULL,   0,   B_SIG_GNT       }, 
  {"LOCK"       ,NULL,  50,   1,  1,   NULL,   0,   B_SIG_LOCK      }, 
  {"SDONE"      ,NULL,  55,   1,  1,   NULL,   0,   B_SIG_SDONE     }, 
  {"SBO"        ,NULL,  56,   1,  1,   NULL,   0,   B_SIG_SBO       }, 
  {"PAR"        ,NULL,  53,   1,  0,   NULL,   0,   B_SIG_PAR       }, 
  {"RST"        ,NULL,  39,   1,  1,   NULL,   0,   B_SIG_RESET     }, 
  {"berr"       ,NULL,  54,   1,  1,   NULL,   0,   B_SIG_BERR      }, 
  {"ACK64"      ,NULL,   0,   0,  1,   NULL,   0,   B_SIG_ACK64     }, 
  {"REQ64"      ,NULL,   0,   0,  1,   NULL,   0,   B_SIG_REQ64     }, 
  {"b_state"    ,NULL,  36,   3,  0,   NULL,   4,   B_SIG_b_state   }, 
  {"m_act"      ,NULL,  52,   1,  0,   NULL,   0,   B_SIG_m_act     }, 
  {"t_act"      ,NULL,  51,   1,  0,   NULL,   0,   B_SIG_t_act     }, 
  {"m_lock"     ,NULL,  57,   1,  0,   NULL,   0,   B_SIG_m_lock    }, 
  {"t_lock"     ,NULL,  65,   1,  0,   NULL,   0,   B_SIG_t_lock    }, 
  {"trigger3"   ,NULL,  60,   1,  0,   NULL,   0,   B_SIG_trigger3  }, 
  {"trigger2"   ,NULL,  59,   1,  0,   NULL,   0,   B_SIG_trigger2  }, 
  {"trigger1"   ,NULL,  58,   1,  0,   NULL,   0,   B_SIG_trigger1  }, 
  {"trigger0"   ,NULL,  79,   1,  0,   NULL,   0,   B_SIG_trigger0  }, 
  {"trigger4"   ,NULL,  66,   1,  0,   NULL,   0,   B_SIG_trigger4  }, 
  {"trigger5"   ,NULL,  67,   1,  0,   NULL,   0,   B_SIG_trigger5  }, 
  {"trigger6"   ,NULL,  68,   1,  0,   NULL,   0,   B_SIG_trigger6  }, 
  {"trigger7"   ,NULL,  69,   1,  0,   NULL,   0,   B_SIG_trigger7  }, 
  {"trigger8"   ,NULL,  70,   1,  0,   NULL,   0,   B_SIG_trigger8  }, 
  {"trigger9"   ,NULL,  71,   1,  0,   NULL,   0,   B_SIG_trigger9  }, 
  {"trigger10"  ,NULL,  72,   1,  0,   NULL,   0,   B_SIG_trigger10 }, 
  {"trigger11"  ,NULL,  73,   1,  0,   NULL,   0,   B_SIG_trigger11 }, 
  {"trigger12"  ,NULL,  74,   1,  0,   NULL,   0,   B_SIG_trigger12 }, 
  {"trigger13"  ,NULL,  75,   1,  0,   NULL,   0,   B_SIG_trigger13 }, 
  {"trigger14"  ,NULL,  76,   1,  0,   NULL,   0,   B_SIG_trigger14 }, 
  {"trigger15"  ,NULL,  77,   1,  0,   NULL,   0,   B_SIG_trigger15 }, 
  {"INTA"       ,NULL,  61,   1,  0,   NULL,   0,   B_SIG_INTA      }, 
  {"INTB"       ,NULL,  62,   1,  0,   NULL,   0,   B_SIG_INTB      }, 
  {"INTC"       ,NULL,  63,   1,  0,   NULL,   0,   B_SIG_INTC      }, 
  {"INTD"       ,NULL,  64,   1,  0,   NULL,   0,   B_SIG_INTD      }, 
  { "gap"       ,NULL,  78,   1,  0,   NULL,   0,   B_SIG_gap       }, 
  { "_gapold"   ,NULL,	78,   1,  0,   NULL,   0,   B_SIG_samplequal},
  { "overflow"  ,NULL,  39,   1,  0,   NULL,   0,   B_SIG_overflow  },
  {"_gap_clocks",NULL,   0,  32,  1,   NULL,   0,   B_SIG__gap_clocks},
  {NULL         ,NULL,   0,   0,  0,   NULL,   0,   B_SIG_NO_LABEL  } /* terminating line */
}; 		        


b_param_infotype e2926a_signal_table[] = { 
  /* can be used for e2926a and e2926a deep trace */
  /* blocks are set in dwords (see down ) */
  {"AD32"       ,NULL,  32,  32,  0,   NULL,   0,   B_SIG_AD32       },

  {"AD64"       ,NULL,   0,  32,  0,   NULL,   0,   B_SIG_AD64       },

  {"CBE3_0"     ,NULL,  64,   4,  0,   NULL,   0,   B_SIG_CBE3_0     },
  {"CBE7_4"     ,NULL,  68,   4,  0,   NULL,   4,   B_SIG_CBE7_4     },
  {"FRAME"      ,NULL,  80,   1,  1,   NULL,   0,   B_SIG_FRAME      },
  {"IRDY"       ,NULL,  81,   1,  1,   NULL,   0,   B_SIG_IRDY       },
  {"TRDY"       ,NULL,  82,   1,  1,   NULL,   0,   B_SIG_TRDY       },
  {"DEVSEL"     ,NULL,  83,   1,  1,   NULL,   0,   B_SIG_DEVSEL     },
  {"STOP"       ,NULL,  85,   1,  1,   NULL,   0,   B_SIG_STOP       },
  {"IDSEL"      ,NULL,  84,   1,  0,   NULL,   0,   B_SIG_IDSEL      },
  {"PERR"       ,NULL,  88,   1,  1,   NULL,   0,   B_SIG_PERR       },
  {"SERR"       ,NULL,  89,   1,  1,   NULL,   0,   B_SIG_SERR       },
  {"REQ"        ,NULL,  86,   1,  1,   NULL,   0,   B_SIG_REQ        },
  {"GNT"        ,NULL,  87,   1,  1,   NULL,   0,   B_SIG_GNT        },
  {"LOCK"       ,NULL,  72,   1,  1,   NULL,   0,   B_SIG_LOCK       },
  {"SDONE"      ,NULL,  74,   1,  1,   NULL,   0,   B_SIG_SDONE      },
  {"SBO"        ,NULL,  73,   1,  1,   NULL,   0,   B_SIG_SBO        },
  {"PAR"        ,NULL,  90,   1,  0,   NULL,   0,   B_SIG_PAR        },
  {"RST"        ,NULL,  91,   1,  1,   NULL,   0,   B_SIG_RESET      },
  {"ACK64"      ,NULL,  77,   1,  1,   NULL,   0,   B_SIG_ACK64      },
  {"REQ64"      ,NULL,  76,   1,  1,   NULL,   0,   B_SIG_REQ64      },
  {"PAR64"      ,NULL,  75,   1,  1,   NULL,   0,   B_SIG_PAR64      },
  {"INTA"       ,NULL,  92,   1,  1,   NULL,   0,   B_SIG_INTA       },
  {"INTB"       ,NULL,  93,   1,  1,   NULL,   4,   B_SIG_INTB       },
  {"INTC"       ,NULL,  94,   1,  1,   NULL,   0,   B_SIG_INTC       },
  {"INTD"       ,NULL,  95,   1,  1,   NULL,   0,   B_SIG_INTD       },
  {"m_lock"     ,NULL,  78,   1,  0,   NULL,   0,   B_SIG_m_lock     },
  {"t_lock"     ,NULL,  79,   1,  0,   NULL,   0,   B_SIG_t_lock     },

  {"block_xfer" ,NULL,  96,   8,  0,   NULL,   0,   B_SIG_block_xfer },
  {"attr_ctr"   ,NULL, 104,   8,  0,   NULL,   8,   B_SIG_attr_ctr   },
  {"xact_cmd"   ,NULL, 112,   4,  0,   NULL,  16,   B_SIG_xact_cmd   },
  {"trigger0"   ,NULL, 116,   1,  0,   NULL,   0,   B_SIG_trigger0   },
  {"trigger1"   ,NULL, 117,   1,  0,   NULL,   0,   B_SIG_trigger1   },
  {"trigger2"   ,NULL, 118,   1,  0,   NULL,   0,   B_SIG_trigger2   },
  {"trigger3"   ,NULL, 119,   1,  0,   NULL,   0,   B_SIG_trigger3   },
  {"trigger4"   ,NULL, 120,   1,  0,   NULL,   0,   B_SIG_trigger4   },
  {"trigger5"   ,NULL, 121,   1,  0,   NULL,   0,   B_SIG_trigger5   },
  {"trigger6"   ,NULL, 122,   1,  0,   NULL,   0,   B_SIG_trigger6   },
  {"trigger7"   ,NULL, 123,   1,  0,   NULL,   0,   B_SIG_trigger7   },
  {"trigger8"   ,NULL, 124,   1,  0,   NULL,   0,   B_SIG_trigger8   },
  {"trigger9"   ,NULL, 125,   1,  0,   NULL,   0,   B_SIG_trigger9   },
  {"trigger10"  ,NULL, 126,   1,  0,   NULL,   0,   B_SIG_trigger10  },
  {"trigger11"  ,NULL, 127,   1,  0,   NULL,   0,   B_SIG_trigger11  },

  {"term"       ,NULL, 128,   3,  0,   NULL,   0,   B_SIG_term       },
  {"chck_data"  ,NULL, 131,   1,  0,   NULL,   0,   B_SIG_chck_data  },
  {"m_act"      ,NULL, 132,   1,  1,   NULL,   0,   B_SIG_m_act      },
  {"t_act"      ,NULL, 133,   1,  1,   NULL,   0,   B_SIG_t_act      },
  {"xact_dac"   ,NULL, 134,   1,  1,   NULL,   0,   B_SIG_xact_dac   },
  {"xact_burst" ,NULL, 135,   2,  1,   NULL,   7,   B_SIG_xact_burst },
  {"chk_timing" ,NULL, 137,   1,  1,   NULL,   0,   B_SIG_chk_timing },
  {"xact_req64" ,NULL, 138,   1,  0,   NULL,   0,   B_SIG_xact_req64 },
  {"master_done",NULL, 139,   1,  0,   NULL,   0,   B_SIG_master_done},
  {"decode"     ,NULL, 140,   3,  1,   NULL,  12,   B_SIG_decode     },
  {"gap"        ,NULL, 143,   1,  1,   NULL,   0,   B_SIG_gap        },
  {"_gapold"    ,NULL, 143,   1,  1,   NULL,   0,   B_SIG_samplequal },
#if 0
  /* custom rules are not shown so far */
  {"chk_cst_sum",NULL, 144,   8,  1,   NULL,  16,   B_SIG_chk_cst_sum},
#endif
  {"b_state"    ,NULL, 152,   3,  1,   NULL,  24,   B_SIG_b_state    },
  {"burst"      ,NULL, 155,   3,  1,   NULL,  27,   B_SIG_burst_order},
  {"prot_rule"  ,NULL, 158,   1,  1,   NULL,   0,   B_SIG_prot_rule  },
  {"_berrold"   ,NULL, 158,   1,  1,   NULL,   0,   B_SIG_BERR       },
#if 0
  {"any_c_rule" ,NULL, 159,   1,  1,   NULL,   0,   B_SIG_any_c_rule },
#endif

  {"_gap_clocks",NULL,  64,  32,  1,   NULL,   0,   B_SIG__gap_clocks},
  {"_crr_addrlo",NULL,  32,  32,  1,   NULL,   0,   B_SIG__crr_addrlo},
  {"_crr_addrhi",NULL,   0,  32,  1,   NULL,   0,   B_SIG__crr_addrhi},
  {"_xact_fb2b" ,NULL, 140,   1,  1,   NULL,   0,   B_SIG__xact_fb2b },
  {"_xact_lock" ,NULL, 141,   1,  1,   NULL,   0,   B_SIG__xact_lock },
  {"_trigger0"  ,NULL, 128,   1,  0,   NULL,   0,   B_SIG__trigger0  },
  {"_trigger1"  ,NULL, 129,   1,  0,   NULL,   0,   B_SIG__trigger1  },
  {"_trigger2"  ,NULL, 130,   1,  0,   NULL,   0,   B_SIG__trigger2  },
  {"_trigger3"  ,NULL, 131,   1,  0,   NULL,   0,   B_SIG__trigger3  },
  {"_trigger4"  ,NULL, 132,   1,  0,   NULL,   0,   B_SIG__trigger4  },
  {"_trigger5"  ,NULL, 133,   1,  0,   NULL,   0,   B_SIG__trigger5  },
  {"_trigger6"  ,NULL, 134,   1,  0,   NULL,   0,   B_SIG__trigger6  },
  {"_trigger7"  ,NULL, 135,   1,  0,   NULL,   0,   B_SIG__trigger7  },
  {"_trigger8"  ,NULL, 136,   1,  0,   NULL,   0,   B_SIG__trigger8  },
  {"_trigger9"  ,NULL, 137,   1,  0,   NULL,   0,   B_SIG__trigger9  },
  {"_trigger10" ,NULL, 138,   1,  0,   NULL,   0,   B_SIG__trigger10 },
  {"_trigger11" ,NULL, 139,   1,  0,   NULL,   0,   B_SIG__trigger11 },
  {"_abs_timehi",NULL,  96,  32,  1,   NULL,   0,   B_SIG__abs_timehi},
  {"_abs_timelo",NULL, 144,  16, 16,   NULL,  16,   B_SIG__abs_timelo},
  {"_abs_timeof",NULL, 142,   1,  1,   NULL,   0,   B_SIG__abs_timeof},
  {NULL         ,NULL,   0,   0,  0,   NULL,   0,   B_SIG_NO_LABEL   } /* terminating line */
};

b_param_infotype e2928a_signal_table[] = { 
  /* can be used for e2928a and e2928a deep trace */
  /* blocks are set in dwords (see down ) */
  {"AD32"       ,NULL,  32,  32,  0,   NULL,   0,   B_SIG_AD32       },
  {"AD64"       ,NULL,   0,  32,  0,   NULL,   0,   B_SIG_AD64       },
  {"CBE3_0"     ,NULL,  64,   4,  0,   NULL,   0,   B_SIG_CBE3_0     },
  {"CBE7_4"     ,NULL,  68,   4,  0,   NULL,   4,   B_SIG_CBE7_4     },
  {"FRAME"      ,NULL,  80,   1,  1,   NULL,   0,   B_SIG_FRAME      },
  {"IRDY"       ,NULL,  81,   1,  1,   NULL,   0,   B_SIG_IRDY       },
  {"TRDY"       ,NULL,  82,   1,  1,   NULL,   0,   B_SIG_TRDY       },
  {"DEVSEL"     ,NULL,  83,   1,  1,   NULL,   0,   B_SIG_DEVSEL     },
  {"STOP"       ,NULL,  85,   1,  1,   NULL,   0,   B_SIG_STOP       },
  {"IDSEL"      ,NULL,  84,   1,  0,   NULL,   0,   B_SIG_IDSEL      },
  {"PERR"       ,NULL,  88,   1,  1,   NULL,   0,   B_SIG_PERR       },
  {"SERR"       ,NULL,  89,   1,  1,   NULL,   0,   B_SIG_SERR       },
  {"REQ"        ,NULL,  86,   1,  1,   NULL,   0,   B_SIG_REQ        },
  {"GNT"        ,NULL,  87,   1,  1,   NULL,   0,   B_SIG_GNT        },
  {"LOCK"       ,NULL,  72,   1,  1,   NULL,   0,   B_SIG_LOCK       },
  {"SDONE"      ,NULL,  74,   1,  1,   NULL,   0,   B_SIG_SDONE      },
  {"SBO"        ,NULL,  73,   1,  1,   NULL,   0,   B_SIG_SBO        },
  {"PAR"        ,NULL,  90,   1,  0,   NULL,   0,   B_SIG_PAR        },
  {"RST"        ,NULL,  91,   1,  1,   NULL,   0,   B_SIG_RESET      },
  {"ACK64"      ,NULL,  77,   1,  1,   NULL,   0,   B_SIG_ACK64      },
  {"REQ64"      ,NULL,  76,   1,  1,   NULL,   0,   B_SIG_REQ64      },
  {"PAR64"      ,NULL,  75,   1,  1,   NULL,   0,   B_SIG_PAR64      },
  {"INTA"       ,NULL,  92,   1,  1,   NULL,   0,   B_SIG_INTA       },
  {"INTB"       ,NULL,  93,   1,  1,   NULL,   4,   B_SIG_INTB       },
  {"INTC"       ,NULL,  94,   1,  1,   NULL,   0,   B_SIG_INTC       },
  {"INTD"       ,NULL,  95,   1,  1,   NULL,   0,   B_SIG_INTD       },
  {"block_xfer" ,NULL,  96,   8,  0,   NULL,   0,   B_SIG_block_xfer },
  {"attr_ctr"   ,NULL, 104,   8,  0,   NULL,   8,   B_SIG_attr_ctr   },
  {"xact_cmd"   ,NULL, 112,   4,  0,   NULL,  16,   B_SIG_xact_cmd   },
  {"trigger0"   ,NULL, 116,   1,  0,   NULL,   0,   B_SIG_trigger0   },
  {"trigger1"   ,NULL, 117,   1,  0,   NULL,   0,   B_SIG_trigger1   },
  {"trigger2"   ,NULL, 118,   1,  0,   NULL,   0,   B_SIG_trigger2   },
  {"trigger3"   ,NULL, 119,   1,  0,   NULL,   0,   B_SIG_trigger3   },
  {"trigger4"   ,NULL, 120,   1,  0,   NULL,   0,   B_SIG_trigger4   },
  {"trigger5"   ,NULL, 121,   1,  0,   NULL,   0,   B_SIG_trigger5   },
  {"trigger6"   ,NULL, 122,   1,  0,   NULL,   0,   B_SIG_trigger6   },
  {"trigger7"   ,NULL, 123,   1,  0,   NULL,   0,   B_SIG_trigger7   },
  {"trigger8"   ,NULL, 124,   1,  0,   NULL,   0,   B_SIG_trigger8   },
  {"trigger9"   ,NULL, 125,   1,  0,   NULL,   0,   B_SIG_trigger9   },
  {"trigger10"  ,NULL, 126,   1,  0,   NULL,   0,   B_SIG_trigger10  },
  {"trigger11"  ,NULL, 127,   1,  0,   NULL,   0,   B_SIG_trigger11  },
  {"term"       ,NULL, 128,   3,  0,   NULL,   0,   B_SIG_term       },
  {"chck_data"  ,NULL, 131,   1,  0,   NULL,   0,   B_SIG_chck_data  },
  {"m_act"      ,NULL, 132,   1,  1,   NULL,   0,   B_SIG_m_act      },
  {"t_act"      ,NULL, 133,   1,  1,   NULL,   0,   B_SIG_t_act      },
  {"xact_dac"   ,NULL, 134,   1,  1,   NULL,   0,   B_SIG_xact_dac   },
  {"xact_burst" ,NULL, 135,   2,  1,   NULL,   7,   B_SIG_xact_burst },
  {"chk_timing" ,NULL, 137,   1,  1,   NULL,   0,   B_SIG_chk_timing },
  {"xact_req64" ,NULL, 138,   1,  0,   NULL,   0,   B_SIG_xact_req64 },
  {"master_done",NULL, 139,   1,  0,   NULL,   0,   B_SIG_master_done},
  {"decode"     ,NULL, 140,   3,  1,   NULL,  12,   B_SIG_decode     },
  {"gap"        ,NULL, 143,   1,  1,   NULL,   0,   B_SIG_gap        },
  {"_gapold"    ,NULL, 143,   1,  1,   NULL,   0,   B_SIG_samplequal },
#if 0
  /* custom rules are not shown so far */
  {"chk_cst_sum",NULL, 144,   8,  1,   NULL,  16,   B_SIG_chk_cst_sum},
#endif
  {"b_state"    ,NULL, 152,   3,  1,   NULL,  24,   B_SIG_b_state    },
  {"burst"      ,NULL, 155,   3,  1,   NULL,  27,   B_SIG_burst_order},
  {"prot_rule"  ,NULL, 158,   1,  1,   NULL,   0,   B_SIG_prot_rule  },
  {"_berrold"   ,NULL, 158,   1,  1,   NULL,   0,   B_SIG_BERR       },
#if 0
  {"any_c_rule" ,NULL, 159,   1,  1,   NULL,   0,   B_SIG_any_c_rule },
#endif

  {"_gap_clocks",NULL,  64,  32,  1,   NULL,   0,   B_SIG__gap_clocks},
  {"_crr_addrlo",NULL,  32,  32,  1,   NULL,   0,   B_SIG__crr_addrlo},
  {"_crr_addrhi",NULL,   0,  32,  1,   NULL,   0,   B_SIG__crr_addrhi},
  {"_xact_fb2b" ,NULL, 140,   1,  1,   NULL,   0,   B_SIG__xact_fb2b },
  {"_xact_lock" ,NULL, 141,   1,  1,   NULL,   0,   B_SIG__xact_lock },
  {"_trigger0"  ,NULL, 128,   1,  0,   NULL,   0,   B_SIG__trigger0  },
  {"_trigger1"  ,NULL, 129,   1,  0,   NULL,   0,   B_SIG__trigger1  },
  {"_trigger2"  ,NULL, 130,   1,  0,   NULL,   0,   B_SIG__trigger2  },
  {"_trigger3"  ,NULL, 131,   1,  0,   NULL,   0,   B_SIG__trigger3  },
  {"_trigger4"  ,NULL, 132,   1,  0,   NULL,   0,   B_SIG__trigger4  },
  {"_trigger5"  ,NULL, 133,   1,  0,   NULL,   0,   B_SIG__trigger5  },
  {"_trigger6"  ,NULL, 134,   1,  0,   NULL,   0,   B_SIG__trigger6  },
  {"_trigger7"  ,NULL, 135,   1,  0,   NULL,   0,   B_SIG__trigger7  },
  {"_trigger8"  ,NULL, 136,   1,  0,   NULL,   0,   B_SIG__trigger8  },
  {"_trigger9"  ,NULL, 137,   1,  0,   NULL,   0,   B_SIG__trigger9  },
  {"_trigger10" ,NULL, 138,   1,  0,   NULL,   0,   B_SIG__trigger10 },
  {"_trigger11" ,NULL, 139,   1,  0,   NULL,   0,   B_SIG__trigger11 },
  {"_abs_timehi",NULL,  96,  32,  1,   NULL,   0,   B_SIG__abs_timehi},
  {"_abs_timelo",NULL, 144,  16, 16,   NULL,  16,   B_SIG__abs_timelo},
  {"_abs_timeof",NULL, 142,   1,  1,   NULL,   0,   B_SIG__abs_timeof},
  {NULL         ,NULL,   0,   0,  0,   NULL,   0,   B_SIG_NO_LABEL   } /* terminating line */
};

b_param_infotype e2925b_signal_table[] = { 
  /* can be used for e2925b and e2925b deep trace */
  /* blocks are set in dwords (see down ) */
  /* the E2925B is technically the same as the E2926A but without */
  /* the 64 bit features. All 64 Bit signals are hidden and cannot */
  /* be seen. */
  {"AD32"       ,NULL,  32,  32,  0,   NULL,   0,   B_SIG_AD32       },

  {"CBE3_0"     ,NULL,  64,   4,  0,   NULL,   0,   B_SIG_CBE3_0     },
  {"FRAME"      ,NULL,  80,   1,  1,   NULL,   0,   B_SIG_FRAME      },
  {"IRDY"       ,NULL,  81,   1,  1,   NULL,   0,   B_SIG_IRDY       },
  {"TRDY"       ,NULL,  82,   1,  1,   NULL,   0,   B_SIG_TRDY       },
  {"DEVSEL"     ,NULL,  83,   1,  1,   NULL,   0,   B_SIG_DEVSEL     },
  {"STOP"       ,NULL,  85,   1,  1,   NULL,   0,   B_SIG_STOP       },
  {"IDSEL"      ,NULL,  84,   1,  0,   NULL,   0,   B_SIG_IDSEL      },
  {"PERR"       ,NULL,  88,   1,  1,   NULL,   0,   B_SIG_PERR       },
  {"SERR"       ,NULL,  89,   1,  1,   NULL,   0,   B_SIG_SERR       },
  {"REQ"        ,NULL,  86,   1,  1,   NULL,   0,   B_SIG_REQ        },
  {"GNT"        ,NULL,  87,   1,  1,   NULL,   0,   B_SIG_GNT        },
  {"LOCK"       ,NULL,  72,   1,  1,   NULL,   0,   B_SIG_LOCK       },
  {"SDONE"      ,NULL,  74,   1,  1,   NULL,   0,   B_SIG_SDONE      },
  {"SBO"        ,NULL,  73,   1,  1,   NULL,   0,   B_SIG_SBO        },
  {"PAR"        ,NULL,  90,   1,  0,   NULL,   0,   B_SIG_PAR        },
  {"RST"        ,NULL,  91,   1,  1,   NULL,   0,   B_SIG_RESET      },
  {"ACK64"      ,NULL,  77,   1,  1,   NULL,   0,   B_SIG_ACK64      },
  {"REQ64"      ,NULL,  76,   1,  1,   NULL,   0,   B_SIG_REQ64      },
  {"INTA"       ,NULL,  92,   1,  1,   NULL,   0,   B_SIG_INTA       },
  {"INTB"       ,NULL,  93,   1,  1,   NULL,   4,   B_SIG_INTB       },
  {"INTC"       ,NULL,  94,   1,  1,   NULL,   0,   B_SIG_INTC       },
  {"INTD"       ,NULL,  95,   1,  1,   NULL,   0,   B_SIG_INTD       },
  {"m_lock"     ,NULL,  78,   1,  0,   NULL,   0,   B_SIG_m_lock     },
  {"t_lock"     ,NULL,  79,   1,  0,   NULL,   0,   B_SIG_t_lock     },

  {"block_xfer" ,NULL,  96,   8,  0,   NULL,   0,   B_SIG_block_xfer },
  {"attr_ctr"   ,NULL, 104,   8,  0,   NULL,   8,   B_SIG_attr_ctr   },
  {"xact_cmd"   ,NULL, 112,   4,  0,   NULL,  16,   B_SIG_xact_cmd   },
  {"trigger0"   ,NULL, 116,   1,  0,   NULL,   0,   B_SIG_trigger0   },
  {"trigger1"   ,NULL, 117,   1,  0,   NULL,   0,   B_SIG_trigger1   },
  {"trigger2"   ,NULL, 118,   1,  0,   NULL,   0,   B_SIG_trigger2   },
  {"trigger3"   ,NULL, 119,   1,  0,   NULL,   0,   B_SIG_trigger3   },
  {"trigger4"   ,NULL, 120,   1,  0,   NULL,   0,   B_SIG_trigger4   },
  {"trigger5"   ,NULL, 121,   1,  0,   NULL,   0,   B_SIG_trigger5   },
  {"trigger6"   ,NULL, 122,   1,  0,   NULL,   0,   B_SIG_trigger6   },
  {"trigger7"   ,NULL, 123,   1,  0,   NULL,   0,   B_SIG_trigger7   },
  {"trigger8"   ,NULL, 124,   1,  0,   NULL,   0,   B_SIG_trigger8   },
  {"trigger9"   ,NULL, 125,   1,  0,   NULL,   0,   B_SIG_trigger9   },
  {"trigger10"  ,NULL, 126,   1,  0,   NULL,   0,   B_SIG_trigger10  },
  {"trigger11"  ,NULL, 127,   1,  0,   NULL,   0,   B_SIG_trigger11  },

  {"term"       ,NULL, 128,   3,  0,   NULL,   0,   B_SIG_term       },
  {"chck_data"  ,NULL, 131,   1,  0,   NULL,   0,   B_SIG_chck_data  },
  {"m_act"      ,NULL, 132,   1,  1,   NULL,   0,   B_SIG_m_act      },
  {"t_act"      ,NULL, 133,   1,  1,   NULL,   0,   B_SIG_t_act      },
  {"xact_dac"   ,NULL, 134,   1,  1,   NULL,   0,   B_SIG_xact_dac   },
  {"xact_burst" ,NULL, 135,   2,  1,   NULL,   7,   B_SIG_xact_burst },
  {"chk_timing" ,NULL, 137,   1,  1,   NULL,   0,   B_SIG_chk_timing },
  {"xact_req64" ,NULL, 138,   1,  0,   NULL,   0,   B_SIG_xact_req64 },
  {"master_done",NULL, 139,   1,  0,   NULL,   0,   B_SIG_master_done},
  {"decode"     ,NULL, 140,   3,  1,   NULL,  12,   B_SIG_decode     },
  {"gap"        ,NULL, 143,   1,  1,   NULL,   0,   B_SIG_gap        },
  {"_gapold"    ,NULL, 143,   1,  1,   NULL,   0,   B_SIG_samplequal },
#if 0
  /* custom rules are not shown so far */
  {"chk_cst_sum",NULL, 144,   8,  1,   NULL,  16,   B_SIG_chk_cst_sum},
#endif
  {"b_state"    ,NULL, 152,   3,  1,   NULL,  24,   B_SIG_b_state    },
  {"burst"      ,NULL, 155,   3,  1,   NULL,  27,   B_SIG_burst_order},
  {"prot_rule"  ,NULL, 158,   1,  1,   NULL,   0,   B_SIG_prot_rule  },
  {"_berrold"   ,NULL, 158,   1,  1,   NULL,   0,   B_SIG_BERR       },
#if 0
  {"any_c_rule" ,NULL, 159,   1,  1,   NULL,   0,   B_SIG_any_c_rule },
#endif

  {"_gap_clocks",NULL,  64,  32,  1,   NULL,   0,   B_SIG__gap_clocks},
  {"_crr_addrlo",NULL,  32,  32,  1,   NULL,   0,   B_SIG__crr_addrlo},
  {"_crr_addrhi",NULL,   0,  32,  1,   NULL,   0,   B_SIG__crr_addrhi},
  {"_xact_fb2b" ,NULL, 140,   1,  1,   NULL,   0,   B_SIG__xact_fb2b },
  {"_xact_lock" ,NULL, 141,   1,  1,   NULL,   0,   B_SIG__xact_lock },
  {"_trigger0"  ,NULL, 128,   1,  0,   NULL,   0,   B_SIG__trigger0  },
  {"_trigger1"  ,NULL, 129,   1,  0,   NULL,   0,   B_SIG__trigger1  },
  {"_trigger2"  ,NULL, 130,   1,  0,   NULL,   0,   B_SIG__trigger2  },
  {"_trigger3"  ,NULL, 131,   1,  0,   NULL,   0,   B_SIG__trigger3  },
  {"_trigger4"  ,NULL, 132,   1,  0,   NULL,   0,   B_SIG__trigger4  },
  {"_trigger5"  ,NULL, 133,   1,  0,   NULL,   0,   B_SIG__trigger5  },
  {"_trigger6"  ,NULL, 134,   1,  0,   NULL,   0,   B_SIG__trigger6  },
  {"_trigger7"  ,NULL, 135,   1,  0,   NULL,   0,   B_SIG__trigger7  },
  {"_trigger8"  ,NULL, 136,   1,  0,   NULL,   0,   B_SIG__trigger8  },
  {"_trigger9"  ,NULL, 137,   1,  0,   NULL,   0,   B_SIG__trigger9  },
  {"_trigger10" ,NULL, 138,   1,  0,   NULL,   0,   B_SIG__trigger10 },
  {"_trigger11" ,NULL, 139,   1,  0,   NULL,   0,   B_SIG__trigger11 },
  {"_abs_timehi",NULL,  96,  32,  1,   NULL,   0,   B_SIG__abs_timehi},
  {"_abs_timelo",NULL, 144,  16, 16,   NULL,  16,   B_SIG__abs_timelo},
  {"_abs_timeof",NULL, 142,   1,  1,   NULL,   0,   B_SIG__abs_timeof},
  {NULL         ,NULL,   0,   0,  0,   NULL,   0,   B_SIG_NO_LABEL   } /* terminating line */
};


/* The following lists of signals define the signals for the pattern parser.
   The e2925a has pattern parser for standard analyzer mode and for sequencer
   mode (including performance sequencer). These patterns break the golden
   rule of not having an information twice at two different places.
   It would be too much work to extract the parser information
   out of the right now existing firmware. So we keep a double here to
   satisfy any query for the dynamic capabilities. */

/* no difference between e2926 with and without deep trace */
/* the e2926 is included from outside */
#include "pattdefs.h"

/* information is as follows: 
 *  "Name", NULL (shortname), minval, maxval, bitwidth (defaultval),
 *  NULL (defaultstr), PattInfo (Rule), 0 (Prop), selectiontable .
 *  The selection table is listed above. */

b_param_infotype e2925a_patt_signal_table[] = { 
  {"AD32",        NULL,   0,  0xffffffff, 32, NULL, B_PATT_STD | B_PATT_COND, 0,  NULL              },
  {"CBE3_0",      NULL,   0,  0xf,  4,   NULL,   B_PATT_STD | B_PATT_COND  ,  0,  NULL              },
  {"b_state",     NULL,   0,  0x7,  3,   NULL,   B_PATT_STD | B_PATT_COND  ,  0,  bstate_patt_table },
  {"_adoverflow", NULL,   0,  0x1,  1,   NULL,   0                              ,  0,  NULL              },
  {"m_lock",      NULL,   0,  0x1,  1,   NULL,   B_PATT_STD | B_PATT_COND  ,  0,  std_patt_table    },
  {"m_act",       NULL,   0,  0x1,  1,   NULL,   B_PATT_STD | B_PATT_COND | B_PATT_SQ ,  0,  std_patt_table    },
  {"t_lock",      NULL,   0,  0x1,  1,   NULL,   B_PATT_STD | B_PATT_COND  ,  0,  std_patt_table    },
  {"t_act",       NULL,   0,  0x1,  1,   NULL,   B_PATT_STD | B_PATT_COND | B_PATT_SQ ,  0,  std_patt_table    },
  {"DEVSEL",      NULL,   0,  0x1,  1,   NULL,   B_PATT_STD | B_PATT_COND  ,  0,  std_patt_table    },
  {"IRDY",        NULL,   0,  0x1,  1,   NULL,   B_PATT_STD | B_PATT_COND  ,  0,  std_patt_table    },
  {"TRDY",        NULL,   0,  0x1,  1,   NULL,   B_PATT_STD | B_PATT_COND  ,  0,  std_patt_table    },
  {"FRAME",       NULL,   0,  0x1,  1,   NULL,   B_PATT_STD | B_PATT_COND  ,  0,  std_patt_table    },
  {"SERR",        NULL,   0,  0x1,  1,   NULL,   B_PATT_STD | B_PATT_COND  ,  0,  std_patt_table    },
  {"PERR",        NULL,   0,  0x1,  1,   NULL,   B_PATT_STD | B_PATT_COND  ,  0,  std_patt_table    },
  {"IDSEL",       NULL,   0,  0x1,  1,   NULL,   B_PATT_STD | B_PATT_COND  ,  0,  std_patt_table    },
  {"STOP",        NULL,   0,  0x1,  1,   NULL,   B_PATT_STD | B_PATT_COND  ,  0,  std_patt_table    },
  {"SDONE",       NULL,   0,  0x1,  1,   NULL,   B_PATT_STD | B_PATT_COND  ,  0,  std_patt_table    },
  {"LOCK",        NULL,   0,  0x1,  1,   NULL,   B_PATT_STD | B_PATT_COND  ,  0,  std_patt_table    },
  {"GNT",         NULL,   0,  0x1,  1,   NULL,   B_PATT_STD | B_PATT_COND  ,  0,  std_patt_table    },
  {"REQ",         NULL,   0,  0x1,  1,   NULL,   B_PATT_STD | B_PATT_COND  ,  0,  std_patt_table    },
  {"berr",        NULL,   0,  0x1,  1,   NULL,   B_PATT_STD | B_PATT_COND  ,  0,  std_patt_table    },
  {"RST",         NULL,   0,  0x1,  1,   NULL,   B_PATT_STD | B_PATT_COND  ,  0,  std_patt_table    },
  {"PAR",         NULL,   0,  0x1,  1,   NULL,   B_PATT_STD | B_PATT_COND  ,  0,  std_patt_table    },
  {"SBO",         NULL,   0,  0x1,  1,   NULL,   B_PATT_STD | B_PATT_COND  ,  0,  std_patt_table    },
  {"trigger3",    NULL,   0,  0x1,  1,   NULL,   B_PATT_STD | B_PATT_COND  ,  0,  std_patt_table    },
  {"trigger2",    NULL,   0,  0x1,  1,   NULL,   B_PATT_STD | B_PATT_COND  ,  0,  std_patt_table    },
  {"trigger1",    NULL,   0,  0x1,  1,   NULL,   B_PATT_STD | B_PATT_COND  ,  0,  std_patt_table    },
  {"trigger0",    NULL,   0,  0x1,  1,   NULL,   B_PATT_STD | B_PATT_COND  ,  0,  std_patt_table    },
  {"xact_cmd",    NULL,   0,  0xf,  4,   NULL,   B_PATT_STD | B_PATT_COND | B_PATT_SQ ,  0,  xact_patt_table   },
  {"INTD",        NULL,   0,  0x1,  1,   NULL,   B_PATT_STD | B_PATT_COND  ,  0,  std_patt_table    },
  {"INTC",        NULL,   0,  0x1,  1,   NULL,   B_PATT_STD | B_PATT_COND  ,  0,  std_patt_table    },
  {"INTB",        NULL,   0,  0x1,  1,   NULL,   B_PATT_STD | B_PATT_COND  ,  0,  std_patt_table    },
  {"INTA",        NULL,   0,  0x1,  1,   NULL,   B_PATT_STD | B_PATT_COND  ,  0,  std_patt_table    },
  {NULL,          NULL,   0,  0x0,  0,   NULL,   0,  0  } /* terminating line */
};

b_param_infotype e2925a_deep_patt_signal_table[] = {
  {"AD32",        NULL,   0,  0xffffffff, 32,   NULL,  B_PATT_STD | B_PATT_COND ,  0,  NULL       },
  {"CBE3_0",      NULL,   0,  0xf,  4,   NULL,  B_PATT_STD | B_PATT_COND ,  0,  NULL              },
  {"FRAME",       NULL,   0,  0x7,  1,   NULL,  B_PATT_STD | B_PATT_COND ,  0,  std_patt_table    },
  {"IRDY",        NULL,   0,  0x1,  1,   NULL,  B_PATT_STD | B_PATT_COND ,  0,  std_patt_table    },
  {"TRDY",        NULL,   0,  0x1,  1,   NULL,  B_PATT_STD | B_PATT_COND ,  0,  std_patt_table    },
  {"STOP",        NULL,   0,  0x1,  1,   NULL,  B_PATT_STD | B_PATT_COND ,  0,  std_patt_table    },
  {"DEVSEL",      NULL,   0,  0x1,  1,   NULL,  B_PATT_STD | B_PATT_COND ,  0,  std_patt_table    },
  {"b_state",     NULL,   0,  0x7,  3,   NULL,  B_PATT_STD | B_PATT_COND ,  0,  bstate_patt_table },
  {"xact_cmd",    NULL,   0,  0xf,  4,   NULL,  B_PATT_STD | B_PATT_TRAN | B_PATT_SQ ,  0,  xact_patt_table },
  {"PAR",         NULL,   0,  0x1,  1,   NULL,  B_PATT_STD | B_PATT_COND ,  0,  std_patt_table    },
  {"t_act",       NULL,   0,  0x1,  1,   NULL,  B_PATT_STD | B_PATT_TRAN | B_PATT_SQ ,  0,  std_patt_table  },
  {"m_act",       NULL,   0,  0x1,  1,   NULL,  B_PATT_STD | B_PATT_TRAN | B_PATT_SQ ,  0,  std_patt_table  },
  {"m_lock",      NULL,   0,  0x1,  1,   NULL,  B_PATT_STD | B_PATT_COND ,  0,  std_patt_table    },
  {"t_lock",      NULL,   0,  0x1,  1,   NULL,  B_PATT_STD | B_PATT_COND ,  0,  std_patt_table    },
  {"RST",         NULL,   0,  0x1,  1,   NULL,  B_PATT_STD | B_PATT_COND ,  0,  std_patt_table    },
  {"LOCK",        NULL,   0,  0x1,  1,   NULL,  B_PATT_STD | B_PATT_COND ,  0,  std_patt_table    },
  {"GNT",         NULL,   0,  0x1,  1,   NULL,  B_PATT_STD | B_PATT_COND ,  0,  std_patt_table    },
  {"REQ",         NULL,   0,  0x1,  1,   NULL,  B_PATT_STD | B_PATT_COND ,  0,  std_patt_table    },
  {"SERR",        NULL,   0,  0x1,  1,   NULL,  B_PATT_STD | B_PATT_COND ,  0,  std_patt_table    },
  {"PERR",        NULL,   0,  0x1,  1,   NULL,  B_PATT_STD | B_PATT_COND ,  0,  std_patt_table    },
  {"IDSEL",       NULL,   0,  0x1,  1,   NULL,  B_PATT_STD | B_PATT_COND ,  0,  std_patt_table    },
  {"SBO",         NULL,   0,  0x1,  1,   NULL,  B_PATT_STD | B_PATT_COND ,  0,  std_patt_table    },
  {"SDONE",       NULL,   0,  0x1,  1,   NULL,  B_PATT_STD | B_PATT_COND ,  0,  std_patt_table    },
  {"berr",        NULL,   0,  0x1,  1,   NULL,  B_PATT_STD | B_PATT_COND ,  0,  std_patt_table    },
  {"INTA",        NULL,   0,  0x1,  1,   NULL,  B_PATT_STD | B_PATT_COND ,  0,  std_patt_table    },
  {"INTB",        NULL,   0,  0x1,  1,   NULL,  B_PATT_STD | B_PATT_COND ,  0,  std_patt_table    },
  {"INTC",        NULL,   0,  0x1,  1,   NULL,  B_PATT_STD | B_PATT_COND ,  0,  std_patt_table    },
  {"INTD",        NULL,   0,  0x1,  1,   NULL,  B_PATT_STD | B_PATT_COND ,  0,  std_patt_table    },
  {"trigger0",    NULL,   0,  0x1,  1,   NULL,  B_PATT_STD | B_PATT_COND ,  0,  std_patt_table    },
  {"trigger1",    NULL,   0,  0x1,  1,   NULL,  B_PATT_STD | B_PATT_COND ,  0,  std_patt_table    },
  {"trigger2",    NULL,   0,  0x1,  1,   NULL,  B_PATT_STD | B_PATT_COND ,  0,  std_patt_table    },
  {"trigger3",    NULL,   0,  0x1,  1,   NULL,  B_PATT_STD | B_PATT_COND ,  0,  std_patt_table    },
  {"trigger4",    NULL,   0,  0x1,  1,   NULL,  B_PATT_STD | B_PATT_COND ,  0,  std_patt_table    },
  {"trigger5",    NULL,   0,  0x1,  1,   NULL,  B_PATT_STD | B_PATT_COND ,  0,  std_patt_table    },
  {"trigger6",    NULL,   0,  0x1,  1,   NULL,  B_PATT_STD | B_PATT_COND ,  0,  std_patt_table    },
  {"trigger7",    NULL,   0,  0x1,  1,   NULL,  B_PATT_STD | B_PATT_COND ,  0,  std_patt_table    },
  {"trigger8",    NULL,   0,  0x1,  1,   NULL,  B_PATT_STD | B_PATT_COND ,  0,  std_patt_table    },
  {"trigger9",    NULL,   0,  0x1,  1,   NULL,  B_PATT_STD | B_PATT_COND ,  0,  std_patt_table    },
  {"trigger10",   NULL,   0,  0x1,  1,   NULL,  B_PATT_STD | B_PATT_COND ,  0,  std_patt_table    },
  {"trigger11",   NULL,   0,  0x1,  1,   NULL,  B_PATT_STD | B_PATT_COND ,  0,  std_patt_table    },
  {"trigger12",   NULL,   0,  0x1,  1,   NULL,  B_PATT_STD | B_PATT_COND ,  0,  std_patt_table    },
  {"trigger13",   NULL,   0,  0x1,  1,   NULL,  B_PATT_STD | B_PATT_COND ,  0,  std_patt_table    },
  {"trigger14",   NULL,   0,  0x1,  1,   NULL,  B_PATT_STD | B_PATT_COND ,  0,  std_patt_table    },
  {"trigger15",   NULL,   0,  0x1,  1,   NULL,  B_PATT_STD | B_PATT_COND ,  0,  std_patt_table    },
  {NULL,          NULL,   0,    0,  0,   NULL,  0} /* terminating line */
};

/* Timing Checker signals */
b_param_infotype e2926a_tc_signal_table[] = { 
  {"ACK64"      ,NULL,  76,   1,  0,   NULL,   B_PARAMRULE_ZERO2WIDTH,   B_SIG_ACK64      },
  {"AD32"       ,NULL,  32,  32,  0,   NULL,   B_PARAMRULE_ZERO2WIDTH,   B_SIG_AD32       },
  {"AD64"       ,NULL,   0,  32,  0,   NULL,   B_PARAMRULE_ZERO2WIDTH,   B_SIG_AD64       },
  {"CBE3_0"     ,NULL,  64,   4,  0,   NULL,   B_PARAMRULE_ZERO2WIDTH,   B_SIG_CBE3_0     },
  {"CBE7_4"     ,NULL,  68,   4,  0,   NULL,   B_PARAMRULE_ZERO2WIDTH,   B_SIG_CBE7_4     },
  {"DEVSEL"     ,NULL,  92,   1,  0,   NULL,   B_PARAMRULE_ZERO2WIDTH,   B_SIG_DEVSEL     },
  {"FRAME"      ,NULL,  72,   1,  0,   NULL,   B_PARAMRULE_ZERO2WIDTH,   B_SIG_FRAME      },
  {"IDSEL"      ,NULL,  114,   1,  0,  NULL,   B_PARAMRULE_ZERO2WIDTH,   B_SIG_IDSEL      },
  {"IRDY"       ,NULL,  73,   1,  0,   NULL,   B_PARAMRULE_ZERO2WIDTH,   B_SIG_IRDY       },
  {"LOCK"       ,NULL,  77,   1,  0,   NULL,   B_PARAMRULE_ZERO2WIDTH,   B_SIG_LOCK       },
  {"PAR"        ,NULL,  112,   1,  0,  NULL,   B_PARAMRULE_ZERO2WIDTH,   B_SIG_PAR        },
  {"PAR64"      ,NULL,  113,   1,  0,  NULL,   B_PARAMRULE_ZERO2WIDTH,   B_SIG_PAR64      },
  {"PERR"       ,NULL,  94,   1,  0,   NULL,   B_PARAMRULE_ZERO2WIDTH,   B_SIG_PERR       },
  {"REQ64"      ,NULL,  75,   1,  0,   NULL,   B_PARAMRULE_ZERO2WIDTH,   B_SIG_REQ64      },
  {"SBO"        ,NULL,  78,   1,  0,   NULL,   B_PARAMRULE_ZERO2WIDTH,   B_SIG_SBO        },
  {"SDONE"      ,NULL,  79,   1,  0,   NULL,   B_PARAMRULE_ZERO2WIDTH,   B_SIG_SDONE      },
  {"SERR"       ,NULL,  95,   1,  0,   NULL,   B_PARAMRULE_ZERO2WIDTH,   B_SIG_SERR       },
  {"STOP"       ,NULL,  93,   1,  0,   NULL,   B_PARAMRULE_ZERO2WIDTH,   B_SIG_STOP       },
  {"TRDY"       ,NULL,  74,   1,  0,   NULL,   B_PARAMRULE_ZERO2WIDTH,   B_SIG_TRDY       },
  {"trigger0"   ,NULL, 80,   1,  0,    NULL,   B_PARAMRULE_ZERO2WIDTH,   B_SIG_trigger0   },
  {"trigger1"   ,NULL, 81,   1,  0,    NULL,   B_PARAMRULE_ZERO2WIDTH,   B_SIG_trigger1   },
  {"trigger2"   ,NULL, 82,   1,  0,    NULL,   B_PARAMRULE_ZERO2WIDTH,   B_SIG_trigger2   },
  {"trigger3"   ,NULL, 83,   1,  0,    NULL,   B_PARAMRULE_ZERO2WIDTH,   B_SIG_trigger3   },
  {"trigger4"   ,NULL, 84,   1,  0,    NULL,   B_PARAMRULE_ZERO2WIDTH,   B_SIG_trigger4   },
  {"trigger5"   ,NULL, 85,   1,  0,    NULL,   B_PARAMRULE_ZERO2WIDTH,   B_SIG_trigger5   },
  {"trigger6"   ,NULL, 86,   1,  0,    NULL,   B_PARAMRULE_ZERO2WIDTH,   B_SIG_trigger6   },
  {"trigger7"   ,NULL, 87,   1,  0,    NULL,   B_PARAMRULE_ZERO2WIDTH,   B_SIG_trigger7   },
  {"trigger8"   ,NULL, 88,   1,  0,    NULL,   B_PARAMRULE_ZERO2WIDTH,   B_SIG_trigger8   },
  {"trigger9"   ,NULL, 89,   1,  0,    NULL,   B_PARAMRULE_ZERO2WIDTH,   B_SIG_trigger9   },
  {"trigger10"  ,NULL, 90,   1,  0,    NULL,   B_PARAMRULE_ZERO2WIDTH,   B_SIG_trigger10  },
  {"trigger11"  ,NULL, 91,   1,  0,    NULL,   B_PARAMRULE_ZERO2WIDTH,   B_SIG_trigger11  },
  {NULL         ,NULL,   0,   0,  0,   NULL,   0,   B_SIG_NO_LABEL   } /* terminating line */
};

/* Timing Checker signals for the E2925B */
b_param_infotype e2925b_tc_signal_table[] = { 
  {"ACK64"      ,NULL,  76,   1,  0,   NULL,   B_PARAMRULE_ZERO2WIDTH,   B_SIG_ACK64      },
  {"AD32"       ,NULL,  32,  32,  0,   NULL,   B_PARAMRULE_ZERO2WIDTH,   B_SIG_AD32       },
  {"CBE3_0"     ,NULL,  64,   4,  0,   NULL,   B_PARAMRULE_ZERO2WIDTH,   B_SIG_CBE3_0     },
  {"DEVSEL"     ,NULL,  92,   1,  0,   NULL,   B_PARAMRULE_ZERO2WIDTH,   B_SIG_DEVSEL     },
  {"FRAME"      ,NULL,  72,   1,  0,   NULL,   B_PARAMRULE_ZERO2WIDTH,   B_SIG_FRAME      },
  {"IDSEL"      ,NULL,  114,   1,  0,  NULL,   B_PARAMRULE_ZERO2WIDTH,   B_SIG_IDSEL      },
  {"IRDY"       ,NULL,  73,   1,  0,   NULL,   B_PARAMRULE_ZERO2WIDTH,   B_SIG_IRDY       },
  {"LOCK"       ,NULL,  77,   1,  0,   NULL,   B_PARAMRULE_ZERO2WIDTH,   B_SIG_LOCK       },
  {"PAR"        ,NULL,  112,   1,  0,  NULL,   B_PARAMRULE_ZERO2WIDTH,   B_SIG_PAR        },
  {"PAR64"      ,NULL,  113,   1,  0,  NULL,   B_PARAMRULE_ZERO2WIDTH,   B_SIG_PAR64      },
  {"PERR"       ,NULL,  94,   1,  0,   NULL,   B_PARAMRULE_ZERO2WIDTH,   B_SIG_PERR       },
  {"REQ64"      ,NULL,  75,   1,  0,   NULL,   B_PARAMRULE_ZERO2WIDTH,   B_SIG_REQ64      },
  {"SBO"        ,NULL,  78,   1,  0,   NULL,   B_PARAMRULE_ZERO2WIDTH,   B_SIG_SBO        },
  {"SDONE"      ,NULL,  79,   1,  0,   NULL,   B_PARAMRULE_ZERO2WIDTH,   B_SIG_SDONE      },
  {"SERR"       ,NULL,  95,   1,  0,   NULL,   B_PARAMRULE_ZERO2WIDTH,   B_SIG_SERR       },
  {"STOP"       ,NULL,  93,   1,  0,   NULL,   B_PARAMRULE_ZERO2WIDTH,   B_SIG_STOP       },
  {"TRDY"       ,NULL,  74,   1,  0,   NULL,   B_PARAMRULE_ZERO2WIDTH,   B_SIG_TRDY       },
  {"trigger0"   ,NULL, 80,   1,  0,    NULL,   B_PARAMRULE_ZERO2WIDTH,   B_SIG_trigger0   },
  {"trigger1"   ,NULL, 81,   1,  0,    NULL,   B_PARAMRULE_ZERO2WIDTH,   B_SIG_trigger1   },
  {"trigger2"   ,NULL, 82,   1,  0,    NULL,   B_PARAMRULE_ZERO2WIDTH,   B_SIG_trigger2   },
  {"trigger3"   ,NULL, 83,   1,  0,    NULL,   B_PARAMRULE_ZERO2WIDTH,   B_SIG_trigger3   },
  {"trigger4"   ,NULL, 84,   1,  0,    NULL,   B_PARAMRULE_ZERO2WIDTH,   B_SIG_trigger4   },
  {"trigger5"   ,NULL, 85,   1,  0,    NULL,   B_PARAMRULE_ZERO2WIDTH,   B_SIG_trigger5   },
  {"trigger6"   ,NULL, 86,   1,  0,    NULL,   B_PARAMRULE_ZERO2WIDTH,   B_SIG_trigger6   },
  {"trigger7"   ,NULL, 87,   1,  0,    NULL,   B_PARAMRULE_ZERO2WIDTH,   B_SIG_trigger7   },
  {"trigger8"   ,NULL, 88,   1,  0,    NULL,   B_PARAMRULE_ZERO2WIDTH,   B_SIG_trigger8   },
  {"trigger9"   ,NULL, 89,   1,  0,    NULL,   B_PARAMRULE_ZERO2WIDTH,   B_SIG_trigger9   },
  {"trigger10"  ,NULL, 90,   1,  0,    NULL,   B_PARAMRULE_ZERO2WIDTH,   B_SIG_trigger10  },
  {"trigger11"  ,NULL, 91,   1,  0,    NULL,   B_PARAMRULE_ZERO2WIDTH,   B_SIG_trigger11  },
  {NULL         ,NULL,   0,   0,  0,   NULL,   0,   B_SIG_NO_LABEL   } /* terminating line */
};
